#region References

using System;
using System.Collections;
using System.Data;
using System.Data.SqlClient;
using System.Reflection;
using System.Text;
using Method = System.Reflection.MethodBase;
using STOREDPROC = gov.va.med.vbecs.Common.VbecsStoredProcs;
using TABLE = gov.va.med.vbecs.Common.VbecsTables;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;
using gov.va.med.vbecs.DAL.HL7AL;

#endregion

namespace gov.va.med.vbecs.BOL
{
	#region Header

	///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
	///		///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
	///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
	///<Developers>
	///	<Developer></Developer>
	///</Developers>
	///<SiteName>Hines OIFO</SiteName>
	///<CreationDate></CreationDate>
	///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
	///<summary>
	/// Patient transfusion reaction business object layer class.
	///</summary>

	#endregion

	public class PatientTransfusionReaction : BaseBusinessObject 
	{
		#region Variables

		private System.Data.DataRow _drCurrent;
		private string _transfusionReactionTypeText;

		/// <summary>
		/// UpdateField
		/// </summary>
		private enum UpdateField
		{
			/// <summary>
			/// PartialSaveId
			/// </summary>
			PartialSaveId = 1,
			/// <summary>
			/// RecordStatusCode
			/// </summary>
			RecordStatusCode = 2
		}

		#endregion

		#region Constructors

		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/21/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="4451"> 
		///		<ExpectedInput>DataRow</ExpectedInput>
		///		<ExpectedOutput>PatientTransfusionReaction object</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="4452"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Constructor
		/// </summary>
		/// <param name="dtRow"></param>
		public PatientTransfusionReaction(System.Data.DataRow dtRow)
		{
			System.Data.DataTable dtPtr = DAL.PatientTransfusionReaction.GetEmptyPatientTransfusionReactionTable();

			this._drCurrent = dtPtr.NewRow();
			
			this.LoadFromDataRow(dtRow);
		}

		///<Developers>
		///	<Developer>David Askew</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/21/2004</CreationDate>
		///<TestCases>
		///
		///<Case type="0" testid ="4779"> 
		///		<ExpectedInput>OrderedTest Guid</ExpectedInput>
		///		<ExpectedOutput>PatientTransfusionReaction object</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="4780"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Constructor
		/// </summary>
		/// <param name="orderedTestGuid"></param>
		public PatientTransfusionReaction(Guid orderedTestGuid)
		{
			System.Data.DataTable dtPtr = DAL.PatientTransfusionReaction.GetPatientTransfusionReaction
				(
				orderedTestGuid, Common.LogonUser.LogonUserDivisionCode 
				);

			// Load existing data
			if (dtPtr.Rows.Count > 0)
			{
				this.IsNew = false;
				this._drCurrent = dtPtr.Rows[0];
				this.LoadFromDataRow(this._drCurrent);
			}
				// New Ptr
			else
			{
				this.IsNew = true;
				dtPtr = DAL.PatientTransfusionReaction.GetEmptyPatientTransfusionReactionTable();
				this._drCurrent = dtPtr.NewRow();
				this.PatientTransfusionReactionGuid = Guid.NewGuid();
				this.OrderedTestGuid = orderedTestGuid;
				this.DivisionCode = Common.LogonUser.LogonUserDivisionCode;
				this.RecordStatusCode = Common.RecordStatusCode.Active;
			}
		}

		#endregion
		
		#region Properties

		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/21/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1417"> 
		///		<ExpectedInput>string</ExpectedInput>
		///		<ExpectedOutput>string</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="1430"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// DivisionCode
		/// </summary>
		public string DivisionCode
		{
			get
			{
				if (this._drCurrent.IsNull(TABLE.PatientTransfusionReaction.DivisionCode))
					return String.Empty;

				return this._drCurrent[TABLE.PatientTransfusionReaction.DivisionCode].ToString();
			}
			set
			{
				this._drCurrent[TABLE.PatientTransfusionReaction.DivisionCode] = value;
				this.IsDirty = true;
			}
		}


		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/21/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1521"> 
		///		<ExpectedInput>DateTime</ExpectedInput>
		///		<ExpectedOutput>DateTime</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="1522"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// EntryDateTime
		/// </summary>
		public System.DateTime EntryDateTime
		{
			get
			{
				if (this._drCurrent.IsNull(TABLE.PatientTransfusionReaction.EntryDateTime))
					return System.DateTime.MinValue;

				return (System.DateTime)this._drCurrent[TABLE.PatientTransfusionReaction.EntryDateTime];
			}
			set
			{
				this._drCurrent[TABLE.PatientTransfusionReaction.EntryDateTime] = value;
				this.IsDirty = true;
			}
		}

		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/21/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1758"> 
		///		<ExpectedInput>string</ExpectedInput>
		///		<ExpectedOutput>string</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="1791"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// EntryTechId
		/// </summary>
		public string EntryTechId
		{
			get
			{
				if (this._drCurrent.IsNull(TABLE.PatientTransfusionReaction.EntryTechId))
					return String.Empty;

				return this._drCurrent[TABLE.PatientTransfusionReaction.EntryTechId].ToString();
			}
			set
			{
				this._drCurrent[TABLE.PatientTransfusionReaction.EntryTechId] = value;
				this.IsDirty = true;
			}
		}

		
		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/21/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1792"> 
		///		<ExpectedInput>DateTime</ExpectedInput>
		///		<ExpectedOutput>DateTime</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="1793"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// InvestigatedDateTime
		/// </summary>
		public System.DateTime InvestigatedDateTime
		{
			get
			{
				if (this._drCurrent.IsNull(TABLE.PatientTransfusionReaction.InvestigatedDateTime))
					return System.DateTime.MinValue;

				return (System.DateTime)this._drCurrent[TABLE.PatientTransfusionReaction.InvestigatedDateTime];
			}
			set
			{
				this._drCurrent[TABLE.PatientTransfusionReaction.InvestigatedDateTime] = value;
				this.IsDirty = true;
				//
				RuleBroken(Method.GetCurrentMethod().Name, ((value == DateTime.MinValue) || (value > VBECSDateTime.GetDivisionCurrentDateTime())));
			}
		}

		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/21/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1794"> 
		///		<ExpectedInput>string</ExpectedInput>
		///		<ExpectedOutput>string</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="1795"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// MedicalDirectorName
		/// </summary>
		public string MedicalDirectorName
		{
			get
			{
				if (this._drCurrent.IsNull(TABLE.PatientTransfusionReaction.MedicalDirectorName))
					return String.Empty;

				return this._drCurrent[TABLE.PatientTransfusionReaction.MedicalDirectorName].ToString();
			}
			set
			{
				this._drCurrent[TABLE.PatientTransfusionReaction.MedicalDirectorName] = value;
				this.IsDirty = true;
			}
		}

		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/21/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1796"> 
		///		<ExpectedInput>DateTime</ExpectedInput>
		///		<ExpectedOutput>DateTime</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="1803"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// NotedDateTime
		/// </summary>
		public System.DateTime NotedDateTime
		{
			get
			{
				if (this._drCurrent.IsNull(TABLE.PatientTransfusionReaction.NotedDateTime))
					return System.DateTime.MinValue;

				return (System.DateTime)this._drCurrent[TABLE.PatientTransfusionReaction.NotedDateTime];
			}
			set
			{
				this._drCurrent[TABLE.PatientTransfusionReaction.NotedDateTime] = value;
				this.IsDirty = true;
				//
				RuleBroken(Method.GetCurrentMethod().Name, ((value == DateTime.MinValue) || (value > VBECSDateTime.GetDivisionCurrentDateTime())));
			}
		}

		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/21/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1804"> 
		///		<ExpectedInput>Guid</ExpectedInput>
		///		<ExpectedOutput>Guid</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="1816"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// OrderedTestGuid
		/// </summary>
		public System.Guid OrderedTestGuid
		{
			get
			{
				if (this._drCurrent.IsNull(TABLE.PatientTransfusionReaction.OrderedTestGuid))
					return System.Guid.Empty;

				return (System.Guid)this._drCurrent[TABLE.PatientTransfusionReaction.OrderedTestGuid];
			}
			set
			{
				this._drCurrent[TABLE.PatientTransfusionReaction.OrderedTestGuid] = value;
				this.IsDirty = true;
			}
		}

		///<Developers>
		///	<Developer>Carrie Van Stedum</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/25/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="6497"> 
		///		<ExpectedInput>Valid Parameters</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///
		///<Case type="1" testid ="6498"> 
		///		<ExpectedInput>Invalid Parameters</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// PartialSaveId
		/// Used to indicate how far along the user
		/// is in a TRW.
		/// </summary>
		public Common.PatientTransfusionPartialSaveId PartialSaveId
		{
			get
			{
				if (this._drCurrent.IsNull("PartialSaveId"))
				{
					return Common.PatientTransfusionPartialSaveId.NoDataSaved;
				}
				else
				{
					switch((byte)this._drCurrent["PartialSaveId"])
					{
						case (1):
						{
							return Common.PatientTransfusionPartialSaveId.SpecimenChecksComplete;
						}
						case (2):
						{
							return Common.PatientTransfusionPartialSaveId.ImplicatedUnitsComplete;
						}
						case (3):
						{
							return Common.PatientTransfusionPartialSaveId.SymptomsComplete;
						}
						case (4):
						{
							return Common.PatientTransfusionPartialSaveId.SerologicTestsComplete;
						}
						case (5):
						{
							return Common.PatientTransfusionPartialSaveId.ReportFinalized;
						}
						default:
						{
							return Common.PatientTransfusionPartialSaveId.NoDataSaved;
						}
					}
				}
			}
			set
			{
				this._drCurrent["PartialSaveId"] = value;
				this.IsDirty = true;
			}
		}


		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/21/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1817"> 
		///		<ExpectedInput>Guid</ExpectedInput>
		///		<ExpectedOutput>Guid</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="1824"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// PatientGuid
		/// </summary>
		public System.Guid PatientGuid
		{
			get
			{
				if (this._drCurrent.IsNull(TABLE.PatientTransfusionReaction.PatientGuid))
					return System.Guid.Empty;

				return (System.Guid)this._drCurrent[TABLE.PatientTransfusionReaction.PatientGuid];
			}
			set
			{
				this._drCurrent[TABLE.PatientTransfusionReaction.PatientGuid] = value;
				this.IsDirty = true;
			}
		}

		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/21/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1825"> 
		///		<ExpectedInput>Guid</ExpectedInput>
		///		<ExpectedOutput>Guid</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="1891"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// PatientTransfusionReactionGuid
		/// </summary>
		public System.Guid PatientTransfusionReactionGuid
		{
			get
			{
				if (this._drCurrent.IsNull(TABLE.PatientTransfusionReaction.PatientTransfusionReactionGuid))
					return System.Guid.Empty;

				return (System.Guid)this._drCurrent[TABLE.PatientTransfusionReaction.PatientTransfusionReactionGuid];
			}
			set
			{
				this._drCurrent[TABLE.PatientTransfusionReaction.PatientTransfusionReactionGuid] = value;
				this.IsDirty = true;
			}
		}
		///<Developers>
		///	<Developer>Carrie Van Stedum</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/25/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="6499"> 
		///		<ExpectedInput>Valid Parameters</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///
		///<Case type="1" testid ="6500"> 
		///		<ExpectedInput>Invalid Parameters</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// PostSpecimenClericalChecksOKIndicator
		/// </summary>
		public bool PostSpecimenClericalChecksOKIndicator
		{
			get
			{
				if (this._drCurrent.IsNull("PostSpecimenClericalChecksOkIndicator"))
					return false;

				return (bool)this._drCurrent["PostSpecimenClericalChecksOkIndicator"];
			}
			set
			{
				this._drCurrent["PostSpecimenClericalChecksOkIndicator"] = value;
				this.IsDirty = true;
			}
		}

		///<Developers>
		///	<Developer>Carrie Van Stedum</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/25/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="6501"> 
		///		<ExpectedInput>Valid Parameters</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///
		///<Case type="1" testid ="6502"> 
		///		<ExpectedInput>Invalid Parameters</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// PreSpecimenClericalChecksOKIndicator
		/// </summary>
		public bool PreSpecimenClericalChecksOKIndicator
		{
			get
			{
				if (this._drCurrent.IsNull("PreSpecimenClericalChecksOkIndicator"))
					return false;

				return (bool)this._drCurrent["PreSpecimenClericalChecksOkIndicator"];
			}
			set
			{
				this._drCurrent["PreSpecimenClericalChecksOkIndicator"] = value;
				this.IsDirty = true;
			}
		}

		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/21/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1916"> 
		///		<ExpectedInput>bool</ExpectedInput>
		///		<ExpectedOutput>bool</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="1918"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// PostSpecimenNotAvailableIndicator
		/// </summary>
		public bool PostSpecimenNotAvailableIndicator
		{
			get
			{
				if (this._drCurrent.IsNull(TABLE.PatientTransfusionReaction.PostSpecimenNotAvailableIndicator))
					return false;

				return (bool)this._drCurrent[TABLE.PatientTransfusionReaction.PostSpecimenNotAvailableIndicator];
			}
			set
			{
				this._drCurrent[TABLE.PatientTransfusionReaction.PostSpecimenNotAvailableIndicator] = value;
				this.IsDirty = true;
				//
				RuleBroken("PostSpecimenHemolysisInspectionCode", ((!value) && ((this.PostSpecimenHemolysisInspectionCode == null)||(this.PostSpecimenHemolysisInspectionCode.Trim().Length==0))));
			}
		}

		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/21/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1919"> 
		///		<ExpectedInput>bool</ExpectedInput>
		///		<ExpectedOutput>bool</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="1993"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// PreSpecimenNotAvailableIndicator
		/// </summary>
		public bool PreSpecimenNotAvailableIndicator
		{
			get
			{
				if (this._drCurrent.IsNull(TABLE.PatientTransfusionReaction.PreSpecimenNotAvailableIndicator))
					return false;

				return (bool)this._drCurrent[TABLE.PatientTransfusionReaction.PreSpecimenNotAvailableIndicator];
			}
			set
			{
				this._drCurrent[TABLE.PatientTransfusionReaction.PreSpecimenNotAvailableIndicator] = value;
				this.IsDirty = true;
				//
				RuleBroken("PreSpecimenHemolysisInspectionCode", ((!value) && ((this.PreSpecimenHemolysisInspectionCode == null)||(this.PreSpecimenHemolysisInspectionCode.Trim().Length==0))));
			}
		}

		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/12/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="7565"> 
		///		<ExpectedInput>Valid Parameters</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="7566"> 
		///		<ExpectedInput>Invalid Parameters</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// PreSpecimenHemolysisInspectionCode
		/// </summary>
		public string PreSpecimenHemolysisInspectionCode
		{
			get
			{
				if (this._drCurrent.IsNull(TABLE.PatientTransfusionReaction.PreSpecimenHemolysisInspectionCode))
				{
					return null;
				}
				return this._drCurrent[TABLE.PatientTransfusionReaction.PreSpecimenHemolysisInspectionCode].ToString();
			}
			set
			{
				if (value == null)
				{
					this._drCurrent[TABLE.PatientTransfusionReaction.PreSpecimenHemolysisInspectionCode] = DBNull.Value;
				}
				else
				{
					this._drCurrent[TABLE.PatientTransfusionReaction.PreSpecimenHemolysisInspectionCode] = Convert.ToChar(value);
				}
				this.IsDirty = true;
				//
				RuleBroken(Method.GetCurrentMethod().Name, ((!this.PreSpecimenNotAvailableIndicator) && ((value == null)||(value.Trim().Length==0))));
			}
		}

		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/12/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="7567"> 
		///		<ExpectedInput>Valid Parameters</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="7568"> 
		///		<ExpectedInput>Invalid Parameters</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// PostSpecimenHemolysisInspectionCode
		/// </summary>
		public string PostSpecimenHemolysisInspectionCode
		{
			get
			{
				if (this._drCurrent.IsNull(TABLE.PatientTransfusionReaction.PostSpecimenHemolysisInspectionCode))
				{
					return null;
				}
				return this._drCurrent[TABLE.PatientTransfusionReaction.PostSpecimenHemolysisInspectionCode].ToString();
			}
			set
			{
				if (value == null)
				{
					this._drCurrent[TABLE.PatientTransfusionReaction.PostSpecimenHemolysisInspectionCode] = DBNull.Value;
				}
				else
				{
					this._drCurrent[TABLE.PatientTransfusionReaction.PostSpecimenHemolysisInspectionCode] = Convert.ToChar(value);
				}
				this.IsDirty = true;
				//
				RuleBroken(Method.GetCurrentMethod().Name, ((!this.PostSpecimenNotAvailableIndicator) && ((value == null)||(value.Trim().Length==0))));
			}
		}

		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/21/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1994"> 
		///		<ExpectedInput>Common.RecordStatusCode</ExpectedInput>
		///		<ExpectedOutput>Common.RecordStatusCode</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="2011"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// RecordStatusCode
		/// </summary>
		public Common.RecordStatusCode RecordStatusCode
		{
			get 
			{
				if (_drCurrent.IsNull(TABLE.PatientTransfusionReaction.RecordStatusCode))
				{
					return Common.RecordStatusCode.Unknown;
				}
				return Common.Utility.GetRecordStatusCodeFromString(this._drCurrent[TABLE.PatientTransfusionReaction.RecordStatusCode].ToString());
			}
			set 
			{
				this._drCurrent[TABLE.PatientTransfusionReaction.RecordStatusCode] = Common.Utility.GetRecordStatusCodeCharFromEnum(value);
				this.IsDirty = true;
			}
		}

		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/21/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2063"> 
		///		<ExpectedInput>Common.TransfusionReactionType</ExpectedInput>
		///		<ExpectedOutput>Common.TransfusionReactionType</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="2064"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// TransfusionReactionTypeCode
		/// </summary>
		public Common.TransfusionReactionType TransfusionReactionTypeCode
		{
			get
			{
				if (this._drCurrent.IsNull(TABLE.PatientTransfusionReaction.TransfusionReactionTypeCode))
					return Common.TransfusionReactionType.Unknown;

				return (Common.TransfusionReactionType)this._drCurrent[TABLE.PatientTransfusionReaction.TransfusionReactionTypeCode].ToString()[0];
			}
			set
			{
				this._drCurrent[TABLE.PatientTransfusionReaction.TransfusionReactionTypeCode] = (char)value;
				this.IsDirty = true;
			}
		}

		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/21/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2124"> 
		///		<ExpectedInput>string</ExpectedInput>
		///		<ExpectedOutput>string</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="2129"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// TransfusionReactionTypeText
		/// </summary>
		public string TransfusionReactionTypeText
		{
			get
			{
				return(this._transfusionReactionTypeText);
			}
			set
			{
				this._transfusionReactionTypeText = value;
				this.IsDirty = true;
			}
		}

		/// <summary>
		/// Pre Specimen Guid
		/// </summary>
		public System.Guid PreSpecimenGuid
		{
			get
			{
				if (this._drCurrent.IsNull(TABLE.PatientTransfusionReaction.PreSpecimenGuid))
					return System.Guid.Empty;

				return (System.Guid)this._drCurrent[TABLE.PatientTransfusionReaction.PreSpecimenGuid];
			}
			set
			{
				this._drCurrent[TABLE.PatientTransfusionReaction.PreSpecimenGuid] = value;
				this.IsDirty = true;
			}
		}

		/// <summary>
		/// Post Specimen Guid
		/// </summary>
		public System.Guid PostSpecimenGuid
		{
			get
			{
				if (this._drCurrent.IsNull(TABLE.PatientTransfusionReaction.PostSpecimenGuid))
					return System.Guid.Empty;

				return (System.Guid)this._drCurrent[TABLE.PatientTransfusionReaction.PostSpecimenGuid];
			}
			set
			{
				this._drCurrent[TABLE.PatientTransfusionReaction.PostSpecimenGuid] = value;
				this.IsDirty = true;
			}
		}

		#endregion

		#region Instance Methods

		#region Load Methods

		/// <summary>
		/// Load the object from the datarow parameter
		/// </summary>
		/// <param name="dtRow"></param>
		protected override void LoadFromDataRow(System.Data.DataRow dtRow)
		{
			if (dtRow.Table.Columns.Contains(TABLE.PatientTransfusionReaction.DivisionCode))
			{
				if (!dtRow.IsNull(TABLE.PatientTransfusionReaction.DivisionCode))
				{
					this._drCurrent[TABLE.PatientTransfusionReaction.DivisionCode] = dtRow[TABLE.PatientTransfusionReaction.DivisionCode];
				}
			}

			if (dtRow.Table.Columns.Contains(TABLE.PatientTransfusionReaction.EntryDateTime))
			{
				if (!dtRow.IsNull(TABLE.PatientTransfusionReaction.EntryDateTime))
				{
					this._drCurrent[TABLE.PatientTransfusionReaction.EntryDateTime] = dtRow[TABLE.PatientTransfusionReaction.EntryDateTime];
				}
			}

			if (dtRow.Table.Columns.Contains(TABLE.PatientTransfusionReaction.EntryTechId))
			{
				if (!dtRow.IsNull(TABLE.PatientTransfusionReaction.EntryTechId))
				{
					this._drCurrent[TABLE.PatientTransfusionReaction.EntryTechId] = dtRow[TABLE.PatientTransfusionReaction.EntryTechId];
				}
			}

			if (dtRow.Table.Columns.Contains(TABLE.PatientTransfusionReaction.InvestigatedDateTime))
			{
				if (!dtRow.IsNull(TABLE.PatientTransfusionReaction.InvestigatedDateTime))
				{
					this._drCurrent[TABLE.PatientTransfusionReaction.InvestigatedDateTime] = dtRow[TABLE.PatientTransfusionReaction.InvestigatedDateTime];
				}
			}

			if (dtRow.Table.Columns.Contains(TABLE.PatientTransfusionReaction.LastUpdateDate))
			{
				if (!dtRow.IsNull(TABLE.PatientTransfusionReaction.LastUpdateDate))
				{
					this._drCurrent[TABLE.PatientTransfusionReaction.LastUpdateDate] = dtRow[TABLE.PatientTransfusionReaction.LastUpdateDate];
				}
			}

			if (dtRow.Table.Columns.Contains(TABLE.PatientTransfusionReaction.LastUpdateUser))
			{
				if (!dtRow.IsNull(TABLE.PatientTransfusionReaction.LastUpdateUser))
				{
					this._drCurrent[TABLE.PatientTransfusionReaction.LastUpdateUser] = dtRow[TABLE.PatientTransfusionReaction.LastUpdateUser];
				}
			}

			if (dtRow.Table.Columns.Contains(TABLE.PatientTransfusionReaction.MedicalDirectorName))
			{
				if (!dtRow.IsNull(TABLE.PatientTransfusionReaction.MedicalDirectorName))
				{
					this._drCurrent[TABLE.PatientTransfusionReaction.MedicalDirectorName] = dtRow[TABLE.PatientTransfusionReaction.MedicalDirectorName];
				}
			}

			if (dtRow.Table.Columns.Contains(TABLE.PatientTransfusionReaction.NotedDateTime))
			{
				if (!dtRow.IsNull(TABLE.PatientTransfusionReaction.NotedDateTime))
				{
					this._drCurrent[TABLE.PatientTransfusionReaction.NotedDateTime] = dtRow[TABLE.PatientTransfusionReaction.NotedDateTime];
				}
			}

			if (dtRow.Table.Columns.Contains(TABLE.PatientTransfusionReaction.OrderedTestGuid))
			{
				if (!dtRow.IsNull(TABLE.PatientTransfusionReaction.OrderedTestGuid))
				{
					this._drCurrent[TABLE.PatientTransfusionReaction.OrderedTestGuid] = dtRow[TABLE.PatientTransfusionReaction.OrderedTestGuid];
				}
			}

			if (dtRow.Table.Columns.Contains("PartialSaveId"))
			{
				if (!dtRow.IsNull("PartialSaveId"))
				{
					this._drCurrent["PartialSaveId"] = dtRow["PartialSaveId"];
				}
			}

			if (dtRow.Table.Columns.Contains(TABLE.PatientTransfusionReaction.PatientGuid))
			{
				if (!dtRow.IsNull(TABLE.PatientTransfusionReaction.PatientGuid))
				{
					this._drCurrent[TABLE.PatientTransfusionReaction.PatientGuid] = dtRow[TABLE.PatientTransfusionReaction.PatientGuid];
				}
			}

			if (dtRow.Table.Columns.Contains(TABLE.PatientTransfusionReaction.PatientTransfusionReactionGuid))
			{
				if (!dtRow.IsNull(TABLE.PatientTransfusionReaction.PatientTransfusionReactionGuid))
				{
					this._drCurrent[TABLE.PatientTransfusionReaction.PatientTransfusionReactionGuid] = dtRow[TABLE.PatientTransfusionReaction.PatientTransfusionReactionGuid];
				}
			}

			if (dtRow.Table.Columns.Contains("PostSpecimenClericalChecksOkIndicator"))
			{
				if (!dtRow.IsNull("PostSpecimenClericalChecksOkIndicator"))
				{
					this._drCurrent["PostSpecimenClericalChecksOkIndicator"] = dtRow["PostSpecimenClericalChecksOkIndicator"];
				}
			}
			
			if (dtRow.Table.Columns.Contains("PreSpecimenClericalChecksOkIndicator"))
			{
				if (!dtRow.IsNull("PreSpecimenClericalChecksOkIndicator"))
				{
					this._drCurrent["PreSpecimenClericalChecksOkIndicator"] = dtRow["PreSpecimenClericalChecksOkIndicator"];
				}
			}

			if (dtRow.Table.Columns.Contains(TABLE.PatientTransfusionReaction.PostSpecimenNotAvailableIndicator))
			{
				if (!dtRow.IsNull(TABLE.PatientTransfusionReaction.PostSpecimenNotAvailableIndicator))
				{
					this._drCurrent[TABLE.PatientTransfusionReaction.PostSpecimenNotAvailableIndicator] = dtRow[TABLE.PatientTransfusionReaction.PostSpecimenNotAvailableIndicator];
				}
			}
			
			if (dtRow.Table.Columns.Contains(TABLE.PatientTransfusionReaction.PreSpecimenNotAvailableIndicator))
			{
				if (!dtRow.IsNull(TABLE.PatientTransfusionReaction.PreSpecimenNotAvailableIndicator))
				{
					this._drCurrent[TABLE.PatientTransfusionReaction.PreSpecimenNotAvailableIndicator] = dtRow[TABLE.PatientTransfusionReaction.PreSpecimenNotAvailableIndicator];
				}
			}
			
			if (dtRow.Table.Columns.Contains(TABLE.PatientTransfusionReaction.PostSpecimenHemolysisInspectionCode))
			{
				if (!dtRow.IsNull(TABLE.PatientTransfusionReaction.PostSpecimenHemolysisInspectionCode))
				{
					this._drCurrent[TABLE.PatientTransfusionReaction.PostSpecimenHemolysisInspectionCode] = dtRow[TABLE.PatientTransfusionReaction.PostSpecimenHemolysisInspectionCode];
				}
			}
			
			if (dtRow.Table.Columns.Contains(TABLE.PatientTransfusionReaction.PreSpecimenHemolysisInspectionCode))
			{
				if (!dtRow.IsNull(TABLE.PatientTransfusionReaction.PreSpecimenHemolysisInspectionCode))
				{
					this._drCurrent[TABLE.PatientTransfusionReaction.PreSpecimenHemolysisInspectionCode] = dtRow[TABLE.PatientTransfusionReaction.PreSpecimenHemolysisInspectionCode];
				}
			}

			if (dtRow.Table.Columns.Contains(TABLE.PatientTransfusionReaction.RecordStatusCode))
			{
				if (!dtRow.IsNull(TABLE.PatientTransfusionReaction.RecordStatusCode))
				{
					this._drCurrent[TABLE.PatientTransfusionReaction.RecordStatusCode] = dtRow[TABLE.PatientTransfusionReaction.RecordStatusCode];
				}
			}			
			
			if (dtRow.Table.Columns.Contains(TABLE.PatientTransfusionReaction.RowVersion))
			{
				if (!dtRow.IsNull(TABLE.PatientTransfusionReaction.RowVersion))
				{
					this._drCurrent[TABLE.PatientTransfusionReaction.RowVersion] = dtRow[TABLE.PatientTransfusionReaction.RowVersion];
				}
			}			

			if (dtRow.Table.Columns.Contains(TABLE.PatientTransfusionReaction.TransfusionReactionTypeCode))
			{
				if (!dtRow.IsNull(TABLE.PatientTransfusionReaction.TransfusionReactionTypeCode))
				{
					this._drCurrent[TABLE.PatientTransfusionReaction.TransfusionReactionTypeCode] = dtRow[TABLE.PatientTransfusionReaction.TransfusionReactionTypeCode];
				}
			}

			if (dtRow.Table.Columns.Contains(TABLE.TransfusionReactionType.TransfusionReactionTypeText))
			{
				if (!dtRow.IsNull(TABLE.TransfusionReactionType.TransfusionReactionTypeText))
				{
					this._transfusionReactionTypeText = dtRow[TABLE.TransfusionReactionType.TransfusionReactionTypeText].ToString();
				}
			}

			if (dtRow.Table.Columns.Contains(TABLE.TransfusionReactionType.RowVersion))
			{
				if (!dtRow.IsNull(TABLE.TransfusionReactionType.RowVersion))
				{
					this.RowVersion = (byte [])dtRow[TABLE.TransfusionReactionType.RowVersion];
				}
			}

			if (dtRow.Table.Columns.Contains(TABLE.PatientTransfusionReaction.PreSpecimenGuid))
			{
				if (!dtRow.IsNull(TABLE.PatientTransfusionReaction.PreSpecimenGuid))
				{
					this._drCurrent[TABLE.PatientTransfusionReaction.PreSpecimenGuid] = dtRow[TABLE.PatientTransfusionReaction.PreSpecimenGuid];
				}
			}

			if (dtRow.Table.Columns.Contains(TABLE.PatientTransfusionReaction.PostSpecimenGuid))
			{
				if (!dtRow.IsNull(TABLE.PatientTransfusionReaction.PostSpecimenGuid))
				{
					this._drCurrent[TABLE.PatientTransfusionReaction.PostSpecimenGuid] = dtRow[TABLE.PatientTransfusionReaction.PostSpecimenGuid];
				}
			}

			this.IsNew = false;
			this.IsDirty = true;
		}


		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/20/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2170"> 
		///		<ExpectedInput>DataRow</ExpectedInput>
		///		<ExpectedOutput>Populated DataRow</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="2171"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Loads and returns a datarow with the object data
		/// </summary>
		/// <param name="dtRow"></param>
		/// <returns></returns>
		public override System.Data.DataRow LoadDataRowFromThis(System.Data.DataRow dtRow)
		{
			if (dtRow.Table.Columns.Contains(TABLE.PatientTransfusionReaction.DivisionCode))
			{
				dtRow[TABLE.PatientTransfusionReaction.DivisionCode] = this.DivisionCode;
			}

			if (dtRow.Table.Columns.Contains(TABLE.PatientTransfusionReaction.EntryDateTime))
			{
				dtRow[TABLE.PatientTransfusionReaction.EntryDateTime] = this.EntryDateTime;
			}

			if (dtRow.Table.Columns.Contains(TABLE.PatientTransfusionReaction.EntryTechId))
			{
				dtRow[TABLE.PatientTransfusionReaction.EntryTechId] = this.EntryTechId;
			}

			if (dtRow.Table.Columns.Contains(TABLE.PatientTransfusionReaction.InvestigatedDateTime))
			{
				dtRow[TABLE.PatientTransfusionReaction.InvestigatedDateTime] = this.InvestigatedDateTime;
			}

			if (dtRow.Table.Columns.Contains(TABLE.PatientTransfusionReaction.LastUpdateDate))
			{
				dtRow[TABLE.PatientTransfusionReaction.LastUpdateDate] = this.LastUpdateDate;
			}

			if (dtRow.Table.Columns.Contains(TABLE.PatientTransfusionReaction.LastUpdateUser))
			{
				dtRow[TABLE.PatientTransfusionReaction.LastUpdateUser] = this.LastUpdateUser;
			}

			if (dtRow.Table.Columns.Contains(TABLE.PatientTransfusionReaction.MedicalDirectorName))
			{
				dtRow[TABLE.PatientTransfusionReaction.MedicalDirectorName] = this.MedicalDirectorName;
			}

			if (dtRow.Table.Columns.Contains(TABLE.PatientTransfusionReaction.NotedDateTime))
			{
				dtRow[TABLE.PatientTransfusionReaction.NotedDateTime] = this.NotedDateTime;
			}

			if (dtRow.Table.Columns.Contains(TABLE.PatientTransfusionReaction.OrderedTestGuid))
			{
				dtRow[TABLE.PatientTransfusionReaction.OrderedTestGuid] = this.OrderedTestGuid;
			}

			if (dtRow.Table.Columns.Contains("PartialSaveId"))
			{
				dtRow["PartialSaveId"] = this.PartialSaveId;
			}

			if (dtRow.Table.Columns.Contains(TABLE.PatientTransfusionReaction.PatientGuid))
			{
				dtRow[TABLE.PatientTransfusionReaction.PatientGuid] = this.PatientGuid;
			}

			if (dtRow.Table.Columns.Contains(TABLE.PatientTransfusionReaction.PatientTransfusionReactionGuid))
			{
				dtRow[TABLE.PatientTransfusionReaction.PatientTransfusionReactionGuid] = this.PatientTransfusionReactionGuid;
			}

			if (dtRow.Table.Columns.Contains("PostSpecimenClericalChecksOkIndicator"))
			{
				dtRow["PostSpecimenClericalChecksOkIndicator"] = this.PostSpecimenClericalChecksOKIndicator;
			}

			if (dtRow.Table.Columns.Contains("PreSpecimenClericalChecksOkIndicator"))
			{
				dtRow["PreSpecimenClericalChecksOkIndicator"] = this.PreSpecimenClericalChecksOKIndicator;
			}

			if (dtRow.Table.Columns.Contains(TABLE.PatientTransfusionReaction.PostSpecimenNotAvailableIndicator))
			{
				dtRow[TABLE.PatientTransfusionReaction.PostSpecimenNotAvailableIndicator] = this.PostSpecimenNotAvailableIndicator;
			}

			if (dtRow.Table.Columns.Contains(TABLE.PatientTransfusionReaction.PreSpecimenNotAvailableIndicator))
			{
				dtRow[TABLE.PatientTransfusionReaction.PreSpecimenNotAvailableIndicator] = this.PreSpecimenNotAvailableIndicator;
			}

			if (dtRow.Table.Columns.Contains(TABLE.PatientTransfusionReaction.PostSpecimenHemolysisInspectionCode))
			{
				if (this.PostSpecimenHemolysisInspectionCode != null)
				{
					dtRow[TABLE.PatientTransfusionReaction.PostSpecimenHemolysisInspectionCode] = Convert.ToChar(this.PostSpecimenHemolysisInspectionCode);
				}
			}

			if (dtRow.Table.Columns.Contains(TABLE.PatientTransfusionReaction.PreSpecimenHemolysisInspectionCode))
			{
				if (this.PreSpecimenHemolysisInspectionCode != null)
				{
					dtRow[TABLE.PatientTransfusionReaction.PreSpecimenHemolysisInspectionCode] = Convert.ToChar(this.PreSpecimenHemolysisInspectionCode);
				}
			}

			if (dtRow.Table.Columns.Contains(TABLE.PatientTransfusionReaction.RecordStatusCode))
			{
				dtRow[TABLE.PatientTransfusionReaction.RecordStatusCode] = this.RecordStatusCode;
			}

			if (dtRow.Table.Columns.Contains(TABLE.PatientTransfusionReaction.RowVersion))
			{
				if (!dtRow.IsNull(TABLE.PatientTransfusionReaction.RowVersion))
				{
					dtRow[TABLE.PatientTransfusionReaction.RowVersion] = this.RowVersion;
				}
				else
				{
					dtRow[TABLE.PatientTransfusionReaction.RowVersion] = DBNull.Value;
				}
			}

			if (dtRow.Table.Columns.Contains(TABLE.PatientTransfusionReaction.TransfusionReactionTypeCode))
			{
				dtRow[TABLE.PatientTransfusionReaction.TransfusionReactionTypeCode] = this.TransfusionReactionTypeCode;
			}

			if (dtRow.Table.Columns.Contains(TABLE.PatientTransfusionReaction.PreSpecimenGuid))
			{
				dtRow[TABLE.PatientTransfusionReaction.PreSpecimenGuid] = this.PreSpecimenGuid;
			}

			if (dtRow.Table.Columns.Contains(TABLE.PatientTransfusionReaction.PostSpecimenGuid))
			{
				dtRow[TABLE.PatientTransfusionReaction.PostSpecimenGuid] = this.PostSpecimenGuid;
			}

			return(dtRow);
		}

		#endregion

		#region DataTable Load Methods

		/// <summary>
		/// LoadBloodUnitTestTable
		/// </summary>
		private DataTable LoadBloodUnitTestTable(ArrayList bloodUnitTests)
		{
			DataTable dtBloodUnitTest = new DataTable();
			dtBloodUnitTest.Columns.Add(TABLE.BloodUnitTest.BloodUnitTestGuid, typeof(Guid));
			dtBloodUnitTest.Columns.Add(TABLE.BloodUnitTest.OrderedTestGuid, typeof(Guid));
			dtBloodUnitTest.Columns.Add(TABLE.BloodUnitTest.BloodUnitGuid, typeof(Guid));
			dtBloodUnitTest.Columns.Add(TABLE.BloodUnitTest.BloodTestTypeId, typeof(int));
			dtBloodUnitTest.Columns.Add(TABLE.BloodUnitTest.TestDate, typeof(DateTime));
			dtBloodUnitTest.Columns.Add(TABLE.BloodUnitTest.TestResultId, typeof(string));
			dtBloodUnitTest.Columns.Add(TABLE.BloodUnitTest.EntryMethodCode, typeof(string));
			dtBloodUnitTest.Columns.Add(TABLE.BloodUnitTest.DivisionCode, typeof(string));
			dtBloodUnitTest.Columns.Add(TABLE.BloodUnitTest.LastUpdateUser, typeof(string));
			dtBloodUnitTest.Columns.Add(TABLE.BloodUnitTest.TestTechId, typeof(string));
			dtBloodUnitTest.Columns.Add(TABLE.PatientTransfusionReaction.PatientTransfusionReactionGuid, typeof(Guid));
			dtBloodUnitTest.Columns.Add(TABLE.BloodUnitTest.AutoInstrumentName, typeof(string));
			dtBloodUnitTest.Columns.Add(TABLE.BloodUnitTest.RackGuid, typeof(Guid));
			dtBloodUnitTest.Columns.Add(TABLE.BloodUnitTest.TestComments, typeof(string));
		
			foreach (BloodUnitTest bloodUnitTest in bloodUnitTests)
			{
				DataRow drBloodUnitTest = dtBloodUnitTest.NewRow();
				drBloodUnitTest[TABLE.BloodUnitTest.BloodUnitTestGuid] = bloodUnitTest.BloodUnitTestGuid;
				drBloodUnitTest[TABLE.BloodUnitTest.OrderedTestGuid] = this.OrderedTestGuid;
				drBloodUnitTest[TABLE.BloodUnitTest.BloodUnitGuid] = bloodUnitTest.BloodUnitGuid;
				drBloodUnitTest[TABLE.BloodUnitTest.BloodTestTypeId] = bloodUnitTest.BloodTestTypeObj.BloodTestTypeId;
				drBloodUnitTest[TABLE.BloodUnitTest.TestDate] = bloodUnitTest.TestDate;
				drBloodUnitTest[TABLE.BloodUnitTest.TestResultId] = bloodUnitTest.TestResultId;
				drBloodUnitTest[TABLE.BloodUnitTest.EntryMethodCode] = bloodUnitTest.EntryMethodCode;
				drBloodUnitTest[TABLE.BloodUnitTest.DivisionCode] = Common.LogonUser.LogonUserDivisionCode;
				drBloodUnitTest[TABLE.BloodUnitTest.LastUpdateUser] = Common.LogonUser.LogonUserName;
				drBloodUnitTest[TABLE.BloodUnitTest.TestTechId] = bloodUnitTest.TestTechId;
				drBloodUnitTest[TABLE.PatientTransfusionReaction.PatientTransfusionReactionGuid] = this.PatientTransfusionReactionGuid;
				if ((bloodUnitTest.AutoInstrumentName != null) && (bloodUnitTest.AutoInstrumentName.Trim().Length>0))
				{
					drBloodUnitTest[TABLE.BloodUnitTest.AutoInstrumentName] = bloodUnitTest.AutoInstrumentName;
				}
				if ((bloodUnitTest.Rack != null)&&(bloodUnitTest.Rack.RackGuid != Guid.Empty))
				{
					drBloodUnitTest[TABLE.BloodUnitTest.RackGuid] = bloodUnitTest.Rack.RackGuid;
				}
				else
				{
					drBloodUnitTest[TABLE.BloodUnitTest.RackGuid] = DBNull.Value;
				}
				if ((bloodUnitTest.TestComments != null) && (bloodUnitTest.TestComments.Trim().Length>0))
				{
					drBloodUnitTest[TABLE.BloodUnitTest.TestComments] = bloodUnitTest.TestComments;
				}
				dtBloodUnitTest.Rows.Add(drBloodUnitTest);
			}

			return dtBloodUnitTest;
		}

		/// <summary>
		/// LoadCommentTable
		/// </summary>
		private DataTable LoadCommentTable(ArrayList comments)
		{
			DataTable dtPatientTransfusionComment = new DataTable();
			dtPatientTransfusionComment.Columns.Add(TABLE.PatientTransfusionComment.PatientTransfusionCommentGuid, typeof(Guid));
			dtPatientTransfusionComment.Columns.Add(TABLE.PatientTransfusionComment.PatientTransfusionGuid, typeof(Guid));
			dtPatientTransfusionComment.Columns.Add(TABLE.PatientTransfusionComment.PatientTransfusionReactionGuid, typeof(Guid));
			dtPatientTransfusionComment.Columns.Add(TABLE.PatientTransfusionComment.CannedCommentGuid, typeof(Guid));
			dtPatientTransfusionComment.Columns.Add(TABLE.PatientTransfusionComment.CommentCategoryCode, typeof(string));
			dtPatientTransfusionComment.Columns.Add(TABLE.PatientTransfusionComment.PatientTransfusionCommentText, typeof(string));
			dtPatientTransfusionComment.Columns.Add(TABLE.PatientTransfusionComment.PreTransfusionIndicator, typeof(bool));
			dtPatientTransfusionComment.Columns.Add(TABLE.PatientTransfusionComment.DivisionCode, typeof(string));
			dtPatientTransfusionComment.Columns.Add(TABLE.PatientTransfusionComment.RecordStatusCode, typeof(string));
			dtPatientTransfusionComment.Columns.Add(TABLE.PatientTransfusionComment.LastUpdateUser, typeof(string));

			foreach (PatientTransfusionComment comment in comments)
			{
				DataRow drComment = dtPatientTransfusionComment.NewRow();
				//
				drComment[TABLE.PatientTransfusionComment.PatientTransfusionCommentGuid] = Guid.NewGuid();
				//
				if (!comment.PatientTransfusionGuid.Equals(Guid.Empty))
				{
					drComment[TABLE.PatientTransfusionComment.PatientTransfusionGuid] = comment.PatientTransfusionGuid;
					drComment[TABLE.PatientTransfusionComment.PreTransfusionIndicator] = DBNull.Value;
				}
				else
				{
					drComment[TABLE.PatientTransfusionComment.PatientTransfusionGuid] = DBNull.Value;
					drComment[TABLE.PatientTransfusionComment.PreTransfusionIndicator] = comment.PreTransfusionIndicator;
				}
				//
				if (!comment.PatientTransfusionReactionGuid.Equals(Guid.Empty))
				{
					drComment[TABLE.PatientTransfusionComment.PatientTransfusionReactionGuid] = comment.PatientTransfusionReactionGuid;
				}
				else
				{
					drComment[TABLE.PatientTransfusionComment.PatientTransfusionGuid] = DBNull.Value;
				}
				//
				if (!comment.CannedCommentGuid.Equals(Guid.Empty))
				{
					drComment[TABLE.PatientTransfusionComment.CannedCommentGuid] = comment.CannedCommentGuid;
				}
				else
				{
					drComment[TABLE.PatientTransfusionComment.CannedCommentGuid] = DBNull.Value;
				}
				//
				drComment[TABLE.PatientTransfusionComment.CommentCategoryCode] = comment.CommentCategoryCode;
				drComment[TABLE.PatientTransfusionComment.PatientTransfusionCommentText] = comment.PatientTransfusionCommentText;
				drComment[TABLE.PatientTransfusionComment.DivisionCode] = Common.LogonUser.LogonUserDivisionCode;
				drComment[TABLE.PatientTransfusionComment.RecordStatusCode] = comment.RecordStatusCode;
				drComment[TABLE.PatientTransfusionComment.LastUpdateUser] = Common.LogonUser.LogonUserName;
				dtPatientTransfusionComment.Rows.Add(drComment);
			}

			return dtPatientTransfusionComment;
		}

		/// <summary>
		/// LoadOrderedTestTable
		/// </summary>
		private DataTable LoadOrderedTestTable(OrderedTest orderedTest)
		{
			DataTable dtOrderedTest = new DataTable();
			dtOrderedTest.Columns.Add(TABLE.OrderedTest.OrderedTestGuid, typeof(Guid));
			dtOrderedTest.Columns.Add(TABLE.OrderedTest.TaskStatusCode, typeof(char));
			dtOrderedTest.Columns.Add(TABLE.OrderedTest.OrderStatusCode, typeof(char));
			dtOrderedTest.Columns.Add(TABLE.OrderedTest.LastUpdateUser, typeof(string));
			dtOrderedTest.Columns.Add(TABLE.OrderedTest.RowVersion, typeof(byte []));

			DataRow drOrderedTest = dtOrderedTest.NewRow();
			drOrderedTest[TABLE.OrderedTest.OrderedTestGuid] = orderedTest.OrderedTestGuid;
			drOrderedTest[TABLE.OrderedTest.TaskStatusCode] = orderedTest.TaskStatusCode;
			drOrderedTest[TABLE.OrderedTest.OrderStatusCode] = Common.Utility.GetOrderStatusCodeFromEnum(orderedTest.OrderStatusCode);
			drOrderedTest[TABLE.OrderedTest.LastUpdateUser] = Common.LogonUser.LogonUserName;
			drOrderedTest[TABLE.OrderedTest.RowVersion] = orderedTest.RowVersion;
			dtOrderedTest.Rows.Add(drOrderedTest);

			return dtOrderedTest;
		}

		/// <summary>
		/// LoadPatientTransfusionReactionTable
		/// </summary>
		private DataTable LoadPatientTransfusionReactionTable()
		{
			DataTable dtPatientTransfusionReaction = new DataTable();
			dtPatientTransfusionReaction.Columns.Add(TABLE.PatientTransfusionReaction.PatientTransfusionReactionGuid, typeof(System.Guid));
			dtPatientTransfusionReaction.Columns.Add(TABLE.PatientTransfusionReaction.PatientGuid, typeof(System.Guid));
			dtPatientTransfusionReaction.Columns.Add(TABLE.PatientTransfusionReaction.NotedDateTime, typeof(System.DateTime));
			dtPatientTransfusionReaction.Columns.Add(TABLE.PatientTransfusionReaction.InvestigatedDateTime, typeof(System.DateTime));
			dtPatientTransfusionReaction.Columns.Add(TABLE.PatientTransfusionReaction.EntryTechId, typeof(string));
			dtPatientTransfusionReaction.Columns.Add(TABLE.PatientTransfusionReaction.EntryDateTime, typeof(DateTime));
			dtPatientTransfusionReaction.Columns.Add(TABLE.PatientTransfusionReaction.OrderedTestGuid, typeof(System.Guid));
			dtPatientTransfusionReaction.Columns.Add(TABLE.PatientTransfusionReaction.PreSpecimenNotAvailableIndicator, typeof(bool));
			dtPatientTransfusionReaction.Columns.Add(TABLE.PatientTransfusionReaction.PostSpecimenNotAvailableIndicator, typeof(bool));
			dtPatientTransfusionReaction.Columns.Add(TABLE.PatientTransfusionReaction.PreSpecimenClericalChecksOkIndicator, typeof(bool));
			dtPatientTransfusionReaction.Columns.Add(TABLE.PatientTransfusionReaction.PostSpecimenClericalChecksOkIndicator, typeof(bool));
			dtPatientTransfusionReaction.Columns.Add(TABLE.PatientTransfusionReaction.PreSpecimenHemolysisInspectionCode, typeof(char));
			dtPatientTransfusionReaction.Columns.Add(TABLE.PatientTransfusionReaction.PostSpecimenHemolysisInspectionCode, typeof(char));
			dtPatientTransfusionReaction.Columns.Add(TABLE.PatientTransfusionReaction.PartialSaveId, typeof(int));
			dtPatientTransfusionReaction.Columns.Add(TABLE.PatientTransfusionReaction.DivisionCode, typeof(string));
			dtPatientTransfusionReaction.Columns.Add(TABLE.PatientTransfusionReaction.RecordStatusCode, typeof(string));
			dtPatientTransfusionReaction.Columns.Add(TABLE.PatientTransfusionReaction.LastUpdateUser, typeof(string));
			dtPatientTransfusionReaction.Columns.Add(TABLE.PatientTransfusionReaction.PreSpecimenGuid, typeof(System.Guid));
			dtPatientTransfusionReaction.Columns.Add(TABLE.PatientTransfusionReaction.PostSpecimenGuid, typeof(System.Guid));

			DataRow drPatientTransfusionReaction = dtPatientTransfusionReaction.NewRow();
			drPatientTransfusionReaction[TABLE.PatientTransfusionReaction.PatientTransfusionReactionGuid] = this.PatientTransfusionReactionGuid;
			drPatientTransfusionReaction[TABLE.PatientTransfusionReaction.PatientGuid] = this.PatientGuid;
			drPatientTransfusionReaction[TABLE.PatientTransfusionReaction.NotedDateTime] = this.NotedDateTime;
			drPatientTransfusionReaction[TABLE.PatientTransfusionReaction.InvestigatedDateTime] = this.InvestigatedDateTime;
			drPatientTransfusionReaction[TABLE.PatientTransfusionReaction.EntryTechId] = Common.LogonUser.LogonUserName;
			drPatientTransfusionReaction[TABLE.PatientTransfusionReaction.EntryDateTime] = BOL.VBECSDateTime.GetDivisionCurrentDateTime();
			drPatientTransfusionReaction[TABLE.PatientTransfusionReaction.OrderedTestGuid] = this.OrderedTestGuid;
			drPatientTransfusionReaction[TABLE.PatientTransfusionReaction.PreSpecimenNotAvailableIndicator] = this.PreSpecimenNotAvailableIndicator;
			drPatientTransfusionReaction[TABLE.PatientTransfusionReaction.PostSpecimenNotAvailableIndicator] = this.PostSpecimenNotAvailableIndicator;
			drPatientTransfusionReaction[TABLE.PatientTransfusionReaction.PreSpecimenClericalChecksOkIndicator] = this.PreSpecimenClericalChecksOKIndicator;
			drPatientTransfusionReaction[TABLE.PatientTransfusionReaction.PostSpecimenClericalChecksOkIndicator] = this.PostSpecimenClericalChecksOKIndicator;
			if (this.PreSpecimenHemolysisInspectionCode == null)
			{
				drPatientTransfusionReaction[TABLE.PatientTransfusionReaction.PreSpecimenHemolysisInspectionCode] = DBNull.Value;
			}
			else
			{
				drPatientTransfusionReaction[TABLE.PatientTransfusionReaction.PreSpecimenHemolysisInspectionCode] = Convert.ToChar(this.PreSpecimenHemolysisInspectionCode);
			}
			if (this.PostSpecimenHemolysisInspectionCode == null)
			{
				drPatientTransfusionReaction[TABLE.PatientTransfusionReaction.PostSpecimenHemolysisInspectionCode] = DBNull.Value;
			}
			else
			{
				drPatientTransfusionReaction[TABLE.PatientTransfusionReaction.PostSpecimenHemolysisInspectionCode] = Convert.ToChar(this.PostSpecimenHemolysisInspectionCode);
			}
			drPatientTransfusionReaction[TABLE.PatientTransfusionReaction.PartialSaveId] = (byte)this.PartialSaveId;
			drPatientTransfusionReaction[TABLE.PatientTransfusionReaction.DivisionCode] = Common.LogonUser.LogonUserDivisionCode;
			drPatientTransfusionReaction[TABLE.PatientTransfusionReaction.RecordStatusCode] = this.RecordStatusCode;
			drPatientTransfusionReaction[TABLE.PatientTransfusionReaction.LastUpdateUser] = Common.LogonUser.LogonUserName;
			if (this.PreSpecimenGuid == Guid.Empty)
			{
				drPatientTransfusionReaction[TABLE.PatientTransfusionReaction.PreSpecimenGuid] = DBNull.Value;
			}
			else
			{
				drPatientTransfusionReaction[TABLE.PatientTransfusionReaction.PreSpecimenGuid] = this.PreSpecimenGuid;
			}
			if (this.PostSpecimenGuid == Guid.Empty)
			{
				drPatientTransfusionReaction[TABLE.PatientTransfusionReaction.PostSpecimenGuid] = DBNull.Value;
			}
			else
			{
				drPatientTransfusionReaction[TABLE.PatientTransfusionReaction.PostSpecimenGuid] = this.PostSpecimenGuid;
			}
			//
			dtPatientTransfusionReaction.Rows.Add(drPatientTransfusionReaction);
			
			return dtPatientTransfusionReaction;
		}

		/// <summary>
		/// LoadPatientTransfusionReactionUpdateTable
		/// For updates only
		/// </summary>
		private DataTable LoadPatientTransfusionReactionUpdateTable(UpdateField field)
		{
			DataTable dtPatientTransfusionReaction = new DataTable();
			dtPatientTransfusionReaction.Columns.Add(TABLE.PatientTransfusionReaction.PatientTransfusionReactionGuid, typeof(System.Guid));
			dtPatientTransfusionReaction.Columns.Add(TABLE.PatientTransfusionReaction.DivisionCode, typeof(string));
			dtPatientTransfusionReaction.Columns.Add(TABLE.PatientTransfusionReaction.LastUpdateUser, typeof(string));
			dtPatientTransfusionReaction.Columns.Add(TABLE.PatientTransfusionReaction.RowVersion, typeof(byte[]));

			switch(field)
			{
				case (UpdateField.PartialSaveId):
				{
					dtPatientTransfusionReaction.Columns.Add(TABLE.PatientTransfusionReaction.PartialSaveId, typeof(int));
					break;
				}
				case (UpdateField.RecordStatusCode):
				{
					dtPatientTransfusionReaction.Columns.Add(TABLE.PatientTransfusionReaction.RecordStatusCode, typeof(string));
					break;
				}
			}
			
			DataRow drPatientTransfusionReaction = dtPatientTransfusionReaction.NewRow();
			drPatientTransfusionReaction[TABLE.PatientTransfusionReaction.PatientTransfusionReactionGuid] = this.PatientTransfusionReactionGuid;
			drPatientTransfusionReaction[TABLE.PatientTransfusionReaction.DivisionCode] = Common.LogonUser.LogonUserDivisionCode;
			drPatientTransfusionReaction[TABLE.PatientTransfusionReaction.LastUpdateUser] = Common.LogonUser.LogonUserName;
			drPatientTransfusionReaction[TABLE.PatientTransfusionReaction.RowVersion] = this.RowVersion;
			
			switch(field)
			{
				case (UpdateField.PartialSaveId):
				{
					drPatientTransfusionReaction["PartialSaveId"] = this.PartialSaveId;
					break;
				}
				case (UpdateField.RecordStatusCode):
				{
					drPatientTransfusionReaction[TABLE.PatientTransfusionReaction.RecordStatusCode] = Common.Utility.GetRecordStatusCodeCharFromEnum(this.RecordStatusCode);
					break;
				}
			}

			dtPatientTransfusionReaction.Rows.Add(drPatientTransfusionReaction);
			
			return dtPatientTransfusionReaction;
		}

		/// <summary>
		/// LoadSpecimenTestTable
		/// </summary>
		private DataTable LoadSpecimenTestTable(ArrayList postSpecimenTests, ArrayList preSpecimenTests)
		{
			DataTable dtSpecimenTest = new DataTable();
			dtSpecimenTest.Columns.Add(TABLE.SpecimenTest.SpecimenTestGuid, typeof(Guid));
			dtSpecimenTest.Columns.Add(TABLE.SpecimenTest.OrderedTestGuid, typeof(Guid));
			dtSpecimenTest.Columns.Add(TABLE.SpecimenTest.PatientSpecimenGuid, typeof(Guid));
			dtSpecimenTest.Columns.Add(TABLE.SpecimenTest.TestTechId, typeof(string));
			dtSpecimenTest.Columns.Add(TABLE.SpecimenTest.BloodTestTypeId, typeof(int));
			dtSpecimenTest.Columns.Add(TABLE.SpecimenTest.TestResultId, typeof(string));
			dtSpecimenTest.Columns.Add(TABLE.SpecimenTest.TestDate, typeof(DateTime));
			dtSpecimenTest.Columns.Add(TABLE.SpecimenTest.RackGuid, typeof(Guid));
			dtSpecimenTest.Columns.Add(TABLE.SpecimenTest.AutoInstrumentName, typeof(string));
			dtSpecimenTest.Columns.Add(TABLE.SpecimenTest.AutoInstrumentQCIndicator, typeof(bool));
			dtSpecimenTest.Columns.Add(TABLE.SpecimenTest.DivisionCode, typeof(string));
			dtSpecimenTest.Columns.Add(TABLE.SpecimenTest.LastUpdateUser, typeof(string));
			dtSpecimenTest.Columns.Add(TABLE.PatientTransfusionReaction.PatientTransfusionReactionGuid, typeof(Guid));
			dtSpecimenTest.Columns.Add(TABLE.SpecimenTest.TestComments, typeof(string));

			foreach (SpecimenTest specimenTest in postSpecimenTests)
			{
				DataRow drSpecimenTest = dtSpecimenTest.NewRow();
				drSpecimenTest[TABLE.SpecimenTest.SpecimenTestGuid] = specimenTest.SpecimenTestGuid;
				drSpecimenTest[TABLE.SpecimenTest.OrderedTestGuid] = specimenTest.OrderedTest.OrderedTestGuid;
				drSpecimenTest[TABLE.SpecimenTest.PatientSpecimenGuid] = this.PostSpecimenGuid;
				drSpecimenTest[TABLE.SpecimenTest.TestTechId] = specimenTest.TestTechId;
				drSpecimenTest[TABLE.SpecimenTest.BloodTestTypeId] = specimenTest.BloodTestType.BloodTestTypeId;
				drSpecimenTest[TABLE.SpecimenTest.TestResultId] = specimenTest.TestResult.TestResultId;
				drSpecimenTest[TABLE.SpecimenTest.TestDate] = specimenTest.TestDate;
				if ((specimenTest.Rack != null)&&(specimenTest.Rack.RackGuid != Guid.Empty))
				{
					drSpecimenTest[TABLE.SpecimenTest.RackGuid] = specimenTest.Rack.RackGuid;
				}
				else
				{
					drSpecimenTest[TABLE.SpecimenTest.RackGuid] = DBNull.Value;
				}
				if (specimenTest.AutoInstrumentName.Trim().Length>0)
				{
					drSpecimenTest[TABLE.SpecimenTest.AutoInstrumentName] = specimenTest.AutoInstrumentName;
					drSpecimenTest[TABLE.SpecimenTest.AutoInstrumentQCIndicator] = true;
				}
				drSpecimenTest[TABLE.SpecimenTest.DivisionCode] = Common.LogonUser.LogonUserDivisionCode;
				drSpecimenTest[TABLE.SpecimenTest.LastUpdateUser] = Common.LogonUser.LogonUserName;
				drSpecimenTest[TABLE.PatientTransfusionReaction.PatientTransfusionReactionGuid] = this.PatientTransfusionReactionGuid;
				if (specimenTest.TestComments.Trim().Length>0)
				{
					drSpecimenTest[TABLE.SpecimenTest.TestComments] = specimenTest.TestComments;
				}
				dtSpecimenTest.Rows.Add(drSpecimenTest);
			}

			foreach (SpecimenTest specimenTest in preSpecimenTests)
			{
				DataRow drSpecimenTest = dtSpecimenTest.NewRow();
				drSpecimenTest[TABLE.SpecimenTest.SpecimenTestGuid] = specimenTest.SpecimenTestGuid;
				drSpecimenTest[TABLE.SpecimenTest.OrderedTestGuid] = specimenTest.OrderedTest.OrderedTestGuid;
				drSpecimenTest[TABLE.SpecimenTest.PatientSpecimenGuid] = this.PreSpecimenGuid;
				drSpecimenTest[TABLE.SpecimenTest.TestTechId] = specimenTest.TestTechId;
				drSpecimenTest[TABLE.SpecimenTest.BloodTestTypeId] = specimenTest.BloodTestType.BloodTestTypeId;
				drSpecimenTest[TABLE.SpecimenTest.TestResultId] = specimenTest.TestResult.TestResultId;
				drSpecimenTest[TABLE.SpecimenTest.TestDate] = specimenTest.TestDate;
				if ((specimenTest.Rack != null)&&(specimenTest.Rack.RackGuid != Guid.Empty))
				{
					drSpecimenTest[TABLE.SpecimenTest.RackGuid] = specimenTest.Rack.RackGuid;
				}
				else
				{
					drSpecimenTest[TABLE.SpecimenTest.RackGuid] = DBNull.Value;
				}
				if (specimenTest.AutoInstrumentName.Trim().Length>0)
				{
					drSpecimenTest[TABLE.SpecimenTest.AutoInstrumentName] = specimenTest.AutoInstrumentName;
					drSpecimenTest[TABLE.SpecimenTest.AutoInstrumentQCIndicator] = true;
				}
				drSpecimenTest[TABLE.SpecimenTest.DivisionCode] = Common.LogonUser.LogonUserDivisionCode;
				drSpecimenTest[TABLE.SpecimenTest.LastUpdateUser] = Common.LogonUser.LogonUserName;
				drSpecimenTest[TABLE.PatientTransfusionReaction.PatientTransfusionReactionGuid] = this.PatientTransfusionReactionGuid;
				if (specimenTest.TestComments.Trim().Length>0)
				{
					drSpecimenTest[TABLE.SpecimenTest.TestComments] = specimenTest.TestComments;
				}
				dtSpecimenTest.Rows.Add(drSpecimenTest);
			}

			return dtSpecimenTest;
		}

		/// <summary>
		/// LoadSymptomTable
		/// </summary>
		private DataTable LoadSymptomTable(ArrayList symptoms)
		{
			System.Data.DataTable dtExistingData = DAL.PatientTransfusionReaction.GetSymtoms(this.PatientTransfusionReactionGuid, Common.LogonUser.LogonUserDivisionCode);

			DataTable dtSavePTRSymptoms = new DataTable();
			dtSavePTRSymptoms.Columns.Add(TABLE.PatientTransfusionReactionSymptom.PatientTransfusionReactionGuid, typeof(Guid));
			dtSavePTRSymptoms.Columns.Add(TABLE.PatientTransfusionReactionSymptom.PatientSymptomId, typeof(System.Int16));
			dtSavePTRSymptoms.Columns.Add(TABLE.PatientTransfusionReactionSymptom.SortColumn, typeof(System.Int16));
			dtSavePTRSymptoms.Columns.Add(TABLE.PatientTransfusionReactionSymptom.LastUpdateUser, typeof(string));
	
			foreach (ArrayList symptom in symptoms)
			{
				bool recordExists = false;

				foreach(System.Data.DataRow drExisting in dtExistingData.Rows)
				{
					if (System.Convert.ToInt16(drExisting[TABLE.PatientTransfusionReactionSymptom.PatientSymptomId]) == System.Convert.ToInt16(symptom[0]))
					{
						recordExists = true;
						break;
					}
				}

				if (!recordExists)
				{
					DataRow drSymptom = dtSavePTRSymptoms.NewRow();
					drSymptom[TABLE.PatientTransfusionReactionSymptom.PatientTransfusionReactionGuid] = this.PatientTransfusionReactionGuid;
					drSymptom[TABLE.PatientTransfusionReactionSymptom.PatientSymptomId] = System.Convert.ToInt16(symptom[0]);
					drSymptom[TABLE.PatientTransfusionReactionSymptom.SortColumn] = System.Convert.ToInt16(symptom[2]);
					drSymptom[TABLE.PatientTransfusionReactionSymptom.LastUpdateUser] = Common.LogonUser.LogonUserName;
					dtSavePTRSymptoms.Rows.Add(drSymptom);
				}
			}
			return dtSavePTRSymptoms;
		}

		/// <summary>
		/// LoadTransfusionReactionTable
		/// </summary>
		private DataTable LoadTransfusionReactionTable(ArrayList transfusionReactionList)
		{
			DataTable dtTransfusionReaction = new DataTable();
			dtTransfusionReaction.Columns.Add(TABLE.TransfusionReaction.TransfusionReactionGuid, typeof(System.Guid));
			dtTransfusionReaction.Columns.Add(TABLE.TransfusionReaction.PatientTransfusionReactionGuid, typeof(Guid));
			dtTransfusionReaction.Columns.Add(TABLE.TransfusionReaction.PatientTransfusionGuid, typeof(Guid));
			dtTransfusionReaction.Columns.Add(TABLE.TransfusionReaction.BagReturnedIndicator, typeof(byte));
			dtTransfusionReaction.Columns.Add(TABLE.TransfusionReaction.BagHemolysisInspectionCode, typeof(char));
			dtTransfusionReaction.Columns.Add(TABLE.TransfusionReaction.BagClericalChecksOkIndicator, typeof(byte));
			dtTransfusionReaction.Columns.Add(TABLE.TransfusionReaction.TagNotScannedIndicator, typeof(byte));
			dtTransfusionReaction.Columns.Add(TABLE.TransfusionReaction.LastUpdateUser, typeof(string));

			foreach (TransfusionReaction transfusionReaction in transfusionReactionList)
			{			
				DataRow drTransfusionReaction = dtTransfusionReaction.NewRow();
				drTransfusionReaction[TABLE.TransfusionReaction.TransfusionReactionGuid] = System.Guid.NewGuid();
				drTransfusionReaction[TABLE.TransfusionReaction.PatientTransfusionReactionGuid] = this.PatientTransfusionReactionGuid;
				drTransfusionReaction[TABLE.TransfusionReaction.PatientTransfusionGuid] = transfusionReaction.PatientTransfusionGuid;
				drTransfusionReaction[TABLE.TransfusionReaction.BagReturnedIndicator] = transfusionReaction.BagReturnedIndicator;
				if (transfusionReaction.BagReturnedIndicator)
				{
					drTransfusionReaction[TABLE.TransfusionReaction.BagHemolysisInspectionCode] = Convert.ToChar(transfusionReaction.BagHemolysisInspectionCode);
					drTransfusionReaction[TABLE.TransfusionReaction.BagClericalChecksOkIndicator] = transfusionReaction.BagClericalChecksOkIndicator;
				}
				else
				{
					drTransfusionReaction[TABLE.TransfusionReaction.BagHemolysisInspectionCode] = DBNull.Value;
					drTransfusionReaction[TABLE.TransfusionReaction.BagClericalChecksOkIndicator] = DBNull.Value;
				}
				drTransfusionReaction[TABLE.TransfusionReaction.TagNotScannedIndicator] = transfusionReaction.TagNotScannedIndicator;
				drTransfusionReaction[TABLE.TransfusionReaction.LastUpdateUser] = Common.LogonUser.LogonUserName;
				dtTransfusionReaction.Rows.Add(drTransfusionReaction);
			}

			return dtTransfusionReaction;
		}

		#endregion

		///<Developers>
		///	<Developer>David Askew</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/21/2004</CreationDate>
		///<TestCases>
		///
		///<Case type="0" testid ="4731"> 
		///		<ExpectedInput>Patient Guid</ExpectedInput>
		///		<ExpectedOutput>ArrayList</ExpectedOutput>
		///				///	</Case>
		///
		///<Case type="1" testid ="4732"> 
		///		<ExpectedInput>Invalid Patient Guid</ExpectedInput>
		///		<ExpectedOutput>Empty ArrayList</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// GetImplicatedBloodUnits
		/// </summary>
		/// <param name="patientGuid"></param>
		/// <returns></returns>
		public ArrayList GetImplicatedBloodUnits(Guid patientGuid)
		{
			ArrayList bloodUnitList = new ArrayList();
			//
			System.Data.DataTable dt = DAL.PatientTransfusionReaction.GetImplicatedBloodUnits(patientGuid, Common.LogonUser.LogonUserDivisionCode);
			//
			foreach(DataRow dr in dt.Rows)
			{
				bloodUnitList.Add(new BOL.BloodUnit(dr));
			}
			//
			return bloodUnitList;
		}

		///<Developers>
		///	<Developer>David Askew</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/21/2004</CreationDate>
		///<TestCases>
		///
		///<Case type="0" testid ="4733"> 
		///		<ExpectedInput>Valid Patient Guid</ExpectedInput>
		///		<ExpectedOutput>ArrayList</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="4734"> 
		///		<ExpectedInput>Invalid Patient Guid</ExpectedInput>
		///		<ExpectedOutput>Empty ArrayList</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// GetImplicatedBloodUnits
		/// </summary>
		/// <param name="patientGuid"></param>
		/// <returns></returns>
		public ArrayList GetImplicatedTransfusionRecords(Guid patientGuid)
		{
			ArrayList transfusionList = new ArrayList();
			//
			System.Data.DataTable dt = DAL.PatientTransfusionReaction.GetImplicatedTransfusionRecords(patientGuid, Common.LogonUser.LogonUserDivisionCode);
			//
			foreach(DataRow dr in dt.Rows)
			{
				transfusionList.Add(new BOL.PatientTransfusion(dr));
			}
			//
			return transfusionList;
		}

		///<Developers>
		///	<Developer>Rob Heiberger</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/26/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="6514"> 
		///		<ExpectedInput>Valid Parameters</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="6515"> 
		///		<ExpectedInput>Invalid Parameters</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Gets transfusion records implicated in transfusion reaction
		/// </summary>
		/// <returns></returns>
		public ArrayList GetImplicatedTransfusionRecords()
		{
			ArrayList transfusionList = new ArrayList();
			//
			System.Data.DataTable dt = DAL.PatientTransfusionReaction.GetImplicatedTransfusionRecordsForPatientTransfusionReaction(this.PatientTransfusionReactionGuid, Common.LogonUser.LogonUserDivisionCode);
			//
			foreach(DataRow dr in dt.Rows)
			{
				transfusionList.Add(new BOL.BloodUnit(dr));
			}
			//
			return transfusionList;
		}

		///<Developers>
		///	<Developer>David Askew</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/21/2004</CreationDate>
		///<TestCases>
		///
		///<Case type="0" testid ="4735"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>ArrayList</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="4736"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Invalidate
		/// </summary>
		/// <returns>ArrayList of BloodUnitTests</returns>
		public ArrayList GetSerologicBloodUnitTests()
		{
			ArrayList bloodUnitTestList = new ArrayList();
			//
			System.Data.DataTable dt = DAL.PatientTransfusionReaction.GetSerologicBloodUnitTests(this.OrderedTestGuid, Common.LogonUser.LogonUserDivisionCode);
			//
			foreach(DataRow dr in dt.Rows)
			{
				bloodUnitTestList.Add(dr);
			}
			//
			return bloodUnitTestList;
		}

		///<Developers>
		///<Developer>David Askew</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/21/2004</CreationDate>
		///<TestCases>
		///
		///<Case type="0" testid ="4737"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>ArrayList</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="4738"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Invalidate
		/// </summary>
		/// <returns>ArrayList of SpecimenTests</returns>
		public ArrayList GetSerologicSpecimenTests()
		{
			ArrayList specimenTestList = new ArrayList();
			//
			System.Data.DataTable dt = DAL.PatientTransfusionReaction.GetSerologicSpecimenTests(this.OrderedTestGuid, Common.LogonUser.LogonUserDivisionCode);
			//
			foreach(DataRow dr in dt.Rows)
			{
				specimenTestList.Add(dr);
			}
			//
			return specimenTestList;
		}

		///<Developers>
		///	<Developer>David Askew</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/21/2004</CreationDate>
		///<TestCases>
		///
		///<Case type="0" testid ="4739"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>ArrayList</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="4740"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// GetSpecimenChecks
		/// </summary>
		/// <returns>
		/// ArrayList of ArrayLists of:
		/// PatientSymptomId, 
		/// PatientSymptomName
		/// </returns>
		public ArrayList GetSymtoms()
		{
			return TableToList(DAL.PatientTransfusionReaction.GetSymtoms  (this.PatientTransfusionReactionGuid, this.DivisionCode));
		}

		///<Developers>
		///	<Developer>David Askew</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/21/2004</CreationDate>
		///<TestCases>
		///
		///<Case type="0" testid ="5013"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>ArrayList</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="5014"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Gets transfusion reaction records implicated in transfusion reaction
		/// </summary>
		/// <returns>ArrayList of TransfusionReaction objects</returns>
		public ArrayList GetTransfusionReactionRecords()
		{
			ArrayList transfusionReactionList = new ArrayList();
			//
			System.Data.DataTable dt = DAL.PatientTransfusionReaction.GetTransfusionReactionRecords(this.PatientTransfusionReactionGuid);
			//
			foreach(DataRow dr in dt.Rows)
			{
				transfusionReactionList.Add(new BOL.TransfusionReaction(dr));
			}
			//
			return transfusionReactionList;
		}

		///<Developers>
		///	<Developer>David Askew</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/21/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="4457"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>bool</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="4458"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Invalidate
		/// </summary>
		/// <param name="orderedTest">Ordered Test</param>
		/// <returns>success indicator</returns>
		public bool Invalidate(BOL.OrderedTest orderedTest)
		{
			orderedTest.TaskStatusCode = Common.Utility.GetTaskStatusCodeFromEnum(Common.TaskStatus.NotStarted);
			DataTable dtOrderedTest = LoadOrderedTestTable(orderedTest);
			//
			return DAL.PatientTransfusionReaction.Invalidate(this.PatientTransfusionReactionGuid, dtOrderedTest, this.RowVersion);
		}

		///<Developers>
		///	<Developer>Rob Heiberger</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/26/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="6516"> 
		///		<ExpectedInput>Valid patient transfusion reaction workup with serologic test results entered</ExpectedInput>
		///		<ExpectedOutput>Success indicator of true</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="6517"> 
		///		<ExpectedInput>Finalized patient transfusion reaction workup object</ExpectedInput>
		///		<ExpectedOutput>Business object exception thrown</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Invalidate
		/// </summary>
		/// <param name="orderedTest"></param>
		/// <param name="bloodUnitTests"></param>
		/// <param name="specimenTests"></param>
		/// <param name="invalidateComment"></param>
		/// <param name="replaceResults"></param>
		/// <param name="updateFunction"></param>
		/// <param name="patientGuid"></param>
		/// <param name="alWorkloadProcessIds"></param>
		/// <returns></returns>
		public bool Invalidate(BOL.OrderedTest orderedTest, ArrayList bloodUnitTests, ArrayList specimenTests, string invalidateComment, bool replaceResults, Common.UpdateFunction updateFunction, Guid patientGuid, System.Collections.ArrayList alWorkloadProcessIds)
		{
			DataTable dtWorkloadEvent = null;
			if (this.PartialSaveId == Common.PatientTransfusionPartialSaveId.ReportFinalized)
			{
				throw new BOL.BusinessObjectException("Finalized TRW's cannot be invalidated");
			}
			//
			DataTable dtPatientTransfusionReaction = new DataTable();
			dtPatientTransfusionReaction.Columns.Add(TABLE.PatientTransfusionReaction.PatientTransfusionReactionGuid,typeof(Guid));
			dtPatientTransfusionReaction.Columns.Add(TABLE.PatientTransfusionReaction.LastUpdateUser);
			dtPatientTransfusionReaction.Columns.Add(TABLE.PatientTransfusionReaction.DivisionCode);
			dtPatientTransfusionReaction.Columns.Add(TABLE.PatientTransfusionReaction.RowVersion,typeof(byte[]));
			DataRow drPatientTransfusionReaction = dtPatientTransfusionReaction.NewRow();
			drPatientTransfusionReaction[TABLE.PatientTransfusionReaction.PatientTransfusionReactionGuid] = this.PatientTransfusionReactionGuid;
			drPatientTransfusionReaction[TABLE.PatientTransfusionReaction.LastUpdateUser] = Common.LogonUser.LogonUserName;
			drPatientTransfusionReaction[TABLE.PatientTransfusionReaction.DivisionCode] = Common.LogonUser.LogonUserDivisionCode;
			drPatientTransfusionReaction[TABLE.PatientTransfusionReaction.RowVersion] = this.RowVersion;
			dtPatientTransfusionReaction.Rows.Add(drPatientTransfusionReaction);
			//
			DataTable dtSpecimenTest = new DataTable();
			dtSpecimenTest.Columns.Add(TABLE.SpecimenTest.SpecimenTestGuid, typeof(Guid));
			dtSpecimenTest.Columns.Add(TABLE.SpecimenTest.RecordStatusCode, typeof(char));
			dtSpecimenTest.Columns.Add(TABLE.SpecimenTest.TestComments, typeof(string));
			dtSpecimenTest.Columns.Add(TABLE.SpecimenTest.InactivateDate, typeof(DateTime));
			dtSpecimenTest.Columns.Add(TABLE.SpecimenTest.InactivateUser, typeof(string));
			dtSpecimenTest.Columns.Add(TABLE.SpecimenTest.RowVersion, typeof(byte[]));
			dtSpecimenTest.Columns.Add(TABLE.SpecimenTest.DivisionCode, typeof(string));
			foreach(DataRow test in specimenTests)
			{
				DataRow drSpecimenTest = dtSpecimenTest.NewRow();
				drSpecimenTest[TABLE.SpecimenTest.SpecimenTestGuid] = (Guid)test[TABLE.SpecimenTest.SpecimenTestGuid];
				drSpecimenTest[TABLE.SpecimenTest.RecordStatusCode] = Common.Utility.GetRecordStatusCodeCharFromEnum(Common.RecordStatusCode.ErrorCorrected);
				drSpecimenTest[TABLE.SpecimenTest.TestComments] = invalidateComment;
				drSpecimenTest[TABLE.SpecimenTest.InactivateDate] = VBECSDateTime.GetDivisionCurrentDateTime();
				drSpecimenTest[TABLE.SpecimenTest.InactivateUser] = Common.LogonUser.LogonUserName;
				drSpecimenTest[TABLE.SpecimenTest.RowVersion] = (byte[])test[TABLE.SpecimenTest.RowVersion];
				drSpecimenTest[TABLE.SpecimenTest.DivisionCode] = Common.LogonUser.LogonUserDivisionCode;
				dtSpecimenTest.Rows.Add(drSpecimenTest);
			}
			//
			//
			DataTable dtBloodUnitTest = new DataTable();
			dtBloodUnitTest.Columns.Add(TABLE.BloodUnitTest.BloodUnitTestGuid, typeof(Guid));
			dtBloodUnitTest.Columns.Add(TABLE.BloodUnitTest.RecordStatusCode, typeof(char));
			dtBloodUnitTest.Columns.Add(TABLE.BloodUnitTest.TestComments, typeof(string));
			dtBloodUnitTest.Columns.Add(TABLE.BloodUnitTest.InactivateDate, typeof(DateTime));
			dtBloodUnitTest.Columns.Add(TABLE.BloodUnitTest.InactivateUser, typeof(string));
			dtBloodUnitTest.Columns.Add(TABLE.BloodUnitTest.RowVersion, typeof(byte[]));
			dtBloodUnitTest.Columns.Add(TABLE.BloodUnitTest.DivisionCode, typeof(string));
			foreach(DataRow test in bloodUnitTests)
			{
				DataRow drBloodUnitTest = dtBloodUnitTest.NewRow();
				drBloodUnitTest[TABLE.BloodUnitTest.BloodUnitTestGuid] = (Guid)test[TABLE.BloodUnitTest.BloodUnitTestGuid];
				drBloodUnitTest[TABLE.BloodUnitTest.RecordStatusCode] = Common.Utility.GetRecordStatusCodeCharFromEnum(Common.RecordStatusCode.ErrorCorrected);
				drBloodUnitTest[TABLE.BloodUnitTest.TestComments] = invalidateComment;
				drBloodUnitTest[TABLE.BloodUnitTest.InactivateDate] = VBECSDateTime.GetDivisionCurrentDateTime();
				drBloodUnitTest[TABLE.BloodUnitTest.InactivateUser] = Common.LogonUser.LogonUserName;
				drBloodUnitTest[TABLE.BloodUnitTest.RowVersion] = (byte[])test[TABLE.BloodUnitTest.RowVersion];
				drBloodUnitTest[TABLE.BloodUnitTest.DivisionCode] = Common.LogonUser.LogonUserDivisionCode;
				dtBloodUnitTest.Rows.Add(drBloodUnitTest);
			}
			//
			//BR_94.07, BR_94.08
			DataTable dtOrderedTest = null;
			if (replaceResults)
			{
				dtOrderedTest = new DataTable(TABLE.OrderedTest.TableName);
				dtOrderedTest.Columns.Add(TABLE.OrderedTest.OrderedTestGuid, typeof(Guid));
				dtOrderedTest.Columns.Add(TABLE.OrderedTest.PatientSpecimenGuid, typeof(Guid));
				dtOrderedTest.Columns.Add(TABLE.OrderedTest.OrderStatusCode, typeof(char));
				dtOrderedTest.Columns.Add(TABLE.OrderedTest.TaskStatusCode, typeof(char));
				dtOrderedTest.Columns.Add(TABLE.OrderedTest.CancellationCannedCommentGuid, typeof(Guid));
				dtOrderedTest.Columns.Add(TABLE.OrderedTest.RowVersion, typeof(byte[]));

				DataRow drOrderedTest = dtOrderedTest.NewRow();
				drOrderedTest[TABLE.OrderedTest.OrderedTestGuid] = orderedTest.OrderedTestGuid;
				drOrderedTest[TABLE.OrderedTest.PatientSpecimenGuid] = orderedTest.Specimen.SpecimenGuid;
				drOrderedTest[TABLE.OrderedTest.OrderStatusCode] = Common.Utility.GetOrderStatusCodeFromEnum(Common.OrderStatus.Accepted);
				drOrderedTest[TABLE.OrderedTest.TaskStatusCode] = Common.Utility.GetTaskStatusCodeFromEnum(Common.TaskStatus.ResultsCorrected);
				drOrderedTest[TABLE.OrderedTest.CancellationCannedCommentGuid] = DBNull.Value;
				drOrderedTest[TABLE.OrderedTest.RowVersion] = orderedTest.RowVersion;
				dtOrderedTest.Rows.Add(drOrderedTest);
			}
			//
			Guid [] patientGuids = new Guid[1];
			patientGuids[0] = patientGuid;												
			for(int nCtr = 0; nCtr < alWorkloadProcessIds.Count; nCtr ++)
			{
				System.Data.DataTable dtWorkloadEventTemp = BOL.WorkloadEvent.GenerateWorkloadData((Common.WorkloadProcessID) alWorkloadProcessIds[nCtr], patientGuids, Common.WorkloadTransactionType.Patient, true);
				if(dtWorkloadEvent == null)
				{
					dtWorkloadEvent = dtWorkloadEventTemp.Clone();
				}
				foreach(System.Data.DataRow dtRow in dtWorkloadEventTemp.Rows)
				{
					DataRow dtNewRow = dtWorkloadEvent.NewRow();
					dtNewRow.ItemArray = dtRow.ItemArray;
					dtWorkloadEvent.Rows.Add(dtNewRow);
				}
			}
			return DAL.PatientTransfusionReaction.Invalidate(dtPatientTransfusionReaction, dtBloodUnitTest, dtSpecimenTest, dtOrderedTest, dtWorkloadEvent, updateFunction);
		}

		///<Developers>
		///	<Developer>D. Askew</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>6/14/2004</CreationDate>
		///<TestCases>
		///
		///<Case type="0" testid ="4741"> 
		///		<ExpectedInput>ArryList of TransfusionReactions and Comments</ExpectedInput>
		///		<ExpectedOutput>true</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="4742"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// SaveImplicatedBloodUnits
		/// </summary>
		/// <param name="transfusionReactionList"></param>
		/// <param name="patientTransfusionCommentList"></param>
		/// <param name="trwExceptions"></param>
		/// <returns></returns>
		public bool SaveImplicatedBloodUnits(ArrayList transfusionReactionList, ArrayList patientTransfusionCommentList, DataTable trwExceptions)
		{
			// Update the partial save id, indicating the implicated units page is complete
			this.PartialSaveId = Common.PatientTransfusionPartialSaveId.ImplicatedUnitsComplete;
			//
			DataTable dtPatientTransfusionReaction = LoadPatientTransfusionReactionUpdateTable(UpdateField.PartialSaveId);
			//
			DataTable dtTransfusionReaction = LoadTransfusionReactionTable(transfusionReactionList);
			//
			DataTable dtPatientTransfusionComment = LoadCommentTable(patientTransfusionCommentList);
			//
			return DAL.PatientTransfusionReaction.SaveImplicatedBloodUnits(dtPatientTransfusionReaction, dtTransfusionReaction, dtPatientTransfusionComment, trwExceptions, Common.UpdateFunction.UC021_FrmTransfusionReactionWorkup);
		}

		///<Developers>
		///	<Developer>D. Askew</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>6/14/2004</CreationDate>
		///<TestCases>
		///
		///<Case type="0" testid ="4743"> 
		///		<ExpectedInput>Arraylist of BloodUnits and Tests</ExpectedInput>
		///		<ExpectedOutput>true</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="4744"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// SaveSerologicTests
		/// </summary>
		/// <param name="bloodUnitTests"></param>
		/// <param name="postSpecimenTests"></param>
		/// <param name="preSpecimenTests"></param>
		/// <param name="orderedTest"></param>
		/// <param name="exceptions"></param>
		/// <param name="workloadProcessIDs"></param>
		/// <returns>success indicator</returns>
		public bool SaveSerologicTests(ArrayList bloodUnitTests, ArrayList postSpecimenTests, ArrayList preSpecimenTests, OrderedTest orderedTest, DataTable exceptions, ArrayList workloadProcessIDs)
		{
			//Create workload data
			System.Guid [] patientGuids = new System.Guid[1];
			patientGuids[0] = this.PatientGuid;
			System.Data.DataTable dtWorkloadEvents = null;
			System.Data.DataTable dtWorkloadTemp = null;

			for (int i=0; i<workloadProcessIDs.Count; i++)
			{
				if (dtWorkloadEvents == null)
				{
					dtWorkloadEvents = BOL.WorkloadEvent.GenerateWorkloadData((Common.WorkloadProcessID)workloadProcessIDs[i], patientGuids, Common.WorkloadTransactionType.Patient, false);
				}
				else
				{
					dtWorkloadTemp = BOL.WorkloadEvent.GenerateWorkloadData((Common.WorkloadProcessID)workloadProcessIDs[i], patientGuids, Common.WorkloadTransactionType.Patient, false);
					if (dtWorkloadTemp.Rows.Count > 0)
					{
						dtWorkloadEvents.Rows.Add(dtWorkloadTemp.Rows[0].ItemArray);
					}
				}
			}
			// Update the partial save id, indicating the serologic tests page is complete
			this.PartialSaveId = Common.PatientTransfusionPartialSaveId.SerologicTestsComplete;
			//
			DataTable dtPatientTransfusionReaction = LoadPatientTransfusionReactionUpdateTable(UpdateField.PartialSaveId);
			//
			DataTable dtSpecimenTest = LoadSpecimenTestTable(postSpecimenTests, preSpecimenTests);
			//
			DataTable dtBloodUnitTest = LoadBloodUnitTestTable(bloodUnitTests);
			//
			orderedTest.TaskStatusCode = Common.Utility.GetTaskStatusCodeFromEnum(Common.TaskStatus.Completed);
			orderedTest.OrderStatusCode = Common.OrderStatus.Complete;
			DataTable dtOrderedTest = LoadOrderedTestTable(orderedTest);
			//
			bool success = DAL.PatientTransfusionReaction.SaveSerologicTests (dtPatientTransfusionReaction, dtSpecimenTest, dtBloodUnitTest, dtOrderedTest, exceptions, Common.UpdateFunction.UC021_FrmTransfusionReactionWorkup, dtWorkloadEvents);
			//
			if (success)
			{
				// updating status of the order in Vista
				DataTable dtOrderedTestForVista = DAL.OrderedTest.GetOrderedTestForVista(orderedTest.CPRSOrderNumber);

				if( dtOrderedTestForVista.Rows.Count > 0 )
				{
					new VbecsOmgMessage().PatientOrderUpdate( dtOrderedTestForVista );
				}
			}
			//
			return success;
		}

		///<Developers>
		///	<Developer>D. Askew</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>6/14/2004</CreationDate>
		///<TestCases>
		///
		///<Case type="0" testid ="4745"> 
		///		<ExpectedInput>Arraylist of Specimens and Tests</ExpectedInput>
		///		<ExpectedOutput>true</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="4746"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// SaveSpecimenCheckData
		/// </summary>
		/// <param name="orderedTest"></param>
		/// <param name="comments"></param>
		/// <param name="exceptions"></param>
		/// <returns>success indicator</returns>
		public bool SaveSpecimenCheckData(OrderedTest orderedTest, ArrayList comments, DataTable exceptions)
		{
			// Update the partial save id, indicating the specimen check page is complete
			this.PartialSaveId = Common.PatientTransfusionPartialSaveId.SpecimenChecksComplete;
			//
			DataTable dtPatientTransfusionReaction = LoadPatientTransfusionReactionTable();
			//
			//DataTable dtPatientSpecimen = LoadSpecimenTable(specimens);
			//
			orderedTest.TaskStatusCode = Common.Utility.GetTaskStatusCodeFromEnum(Common.TaskStatus.PartiallyCompleted);
			DataTable dtOrderedTest = LoadOrderedTestTable(orderedTest);
			//
			DataTable dtPatientTransfusionComment = LoadCommentTable(comments);
			//
			return DAL.PatientTransfusionReaction.SaveSpecimenChecks(dtPatientTransfusionReaction, dtOrderedTest, dtPatientTransfusionComment, exceptions, Common.UpdateFunction.UC021_FrmTransfusionReactionWorkup);
		}

		///<Developers>
		///	<Developer>D. Askew</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>6/14/2004</CreationDate>
		///<TestCases>
		///
		///<Case type="0" testid ="4747"> 
		///		<ExpectedInput>ArrayList of Symptoms, Comment</ExpectedInput>
		///		<ExpectedOutput>true</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="4748"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// SaveSymptoms
		/// </summary>
		/// <param name="symptoms"></param>
		/// <param name="comment"></param>
		/// <returns>success indicator</returns>
		public bool SaveSymptoms(ArrayList symptoms, PatientTransfusionComment comment)
		{
			// Update the partial save id, indicating the symptom page is complete
			this.PartialSaveId = Common.PatientTransfusionPartialSaveId.SymptomsComplete;
			//
			DataTable dtPatientTransfusionReactionSymptom = LoadSymptomTable(symptoms);
			//
			DataTable dtPatientTransfusionReaction = LoadPatientTransfusionReactionUpdateTable(UpdateField.PartialSaveId);
			//
			DataTable dtPatientTransfusionComment = null;
			//
			if (comment != null)
			{
				ArrayList comments = new ArrayList();
				comments.Add(comment);
				dtPatientTransfusionComment = LoadCommentTable(comments);
			}
			// comment is not req'd, dtPatientTransfusionComment will be null if none is supplied
			return DAL.PatientTransfusionReaction.SaveSymptons(dtPatientTransfusionReaction, dtPatientTransfusionReactionSymptom, dtPatientTransfusionComment, Common.UpdateFunction.UC021_FrmTransfusionReactionWorkup);
		}

		///<Developers>
		///	<Developer>D. Askew</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>6/14/2004</CreationDate>
		///<TestCases>
		///
		///<Case type="0" testid ="4749"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>true</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="4750"> 
		///		<ExpectedInput>object with invalid rowversion</ExpectedInput>
		///		<ExpectedOutput>RowVersionException</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// UpdateStatus
		/// </summary>
		/// <returns>success indicator</returns>
		public bool UpdateStatus()
		{
			DataTable dtPatientTransfusionReaction = LoadPatientTransfusionReactionUpdateTable(UpdateField.RecordStatusCode);
			//
			return DAL.PatientTransfusionReaction.UpdateStatus(dtPatientTransfusionReaction, Common.UpdateFunction.UC021_FrmTransfusionReactionWorkup);
		}


		///<Developers>
		///	<Developer>Rob Heiberger</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>2/16/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="6697"> 
		///		<ExpectedInput>Valid patient transfusion reaction workup object with transfusion reaction type set</ExpectedInput>
		///		<ExpectedOutput>Success indicator of true</ExpectedOutput>
		///	</Case>
		///
		///
		///<Case type="1" testid ="6698"> 
		///		<ExpectedInput>Patient transfusion reaction workup object with no transfusion reaction type set</ExpectedInput>
		///		<ExpectedOutput>Data Access Layer exception thrown</ExpectedOutput>
		///	</Case>
		///
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// FinalizeReport
		/// </summary>
		/// <param name="patientTransfusionComment"></param>
		/// <param name="lastUpdateFunctionId"></param>
		/// <returns></returns>
		public bool FinalizeReport(BOL.PatientTransfusionComment patientTransfusionComment, Common.UpdateFunction lastUpdateFunctionId)
		{
			this.PartialSaveId = Common.PatientTransfusionPartialSaveId.ReportFinalized;
			DataTable dtFinalize = this.LoadPatientTransfusionReactionUpdateTable(UpdateField.PartialSaveId);
			//
			dtFinalize.Columns.Add(TABLE.PatientTransfusionReaction.MedicalDirectorName, typeof(string));
			dtFinalize.Columns.Add(TABLE.PatientTransfusionReaction.TransfusionReactionTypeCode, typeof(char));
			//
			foreach(DataRow drFinalize in dtFinalize.Rows)
			{
				drFinalize[TABLE.PatientTransfusionReaction.MedicalDirectorName] = this.MedicalDirectorName;
				drFinalize[TABLE.PatientTransfusionReaction.TransfusionReactionTypeCode] = BOL.TransfusionReactionType.GetTransfusionReactionTypeCharFromEnum(this.TransfusionReactionTypeCode);
			}
			//
			DataTable dtComment = DAL.PatientTransfusionComment.GetEmptyPatientTransfusionCommentTable();
			//
			if ((patientTransfusionComment.CannedCommentGuid != Guid.Empty) || (patientTransfusionComment.PatientTransfusionCommentText.Length>0))
			{
				DataRow dr = dtComment.NewRow();
				//
				if (patientTransfusionComment.CannedCommentGuid != Guid.Empty)
				{
					dr[TABLE.PatientTransfusionComment.CannedCommentGuid] = patientTransfusionComment.CannedCommentGuid;
				}
				dr[TABLE.PatientTransfusionComment.CommentCategoryCode] = patientTransfusionComment.CommentCategoryCode;
				dr[TABLE.PatientTransfusionComment.DivisionCode] = Common.LogonUser.LogonUserDivisionCode;
				dr[TABLE.PatientTransfusionComment.LastUpdateUser] = Common.LogonUser.LogonUserName;
				dr[TABLE.PatientTransfusionComment.PatientTransfusionCommentText] = patientTransfusionComment.PatientTransfusionCommentText;
				dr[TABLE.PatientTransfusionComment.PatientTransfusionReactionGuid] = patientTransfusionComment.PatientTransfusionReactionGuid;
				dr[TABLE.PatientTransfusionComment.PatientTransfusionCommentGuid] = patientTransfusionComment.PatientTransfusionCommentGuid;
				dr[TABLE.PatientTransfusionComment.RecordStatusCode] = Common.Utility.GetRecordStatusCodeCharFromEnum(Common.RecordStatusCode.Active);
				//
				dtComment.Rows.Add(dr);
			}

			return DAL.PatientTransfusionReaction.FinalizeReport(dtFinalize, dtComment, lastUpdateFunctionId);
		}

        /// <summary>
        /// Gets transfusion records implicated in transfusion reaction
        /// </summary>
        /// <param name="patientTransfusionReactionGuid"></param>
        /// <param name="divisionCode"></param>
        /// <returns></returns>
        public static DataTable GetImplicatedTransfusionRecordsForPatientTransfusionReaction(Guid patientTransfusionReactionGuid, string divisionCode)
        {
            return DAL.PatientTransfusionReaction.GetImplicatedTransfusionRecordsForPatientTransfusionReaction(patientTransfusionReactionGuid, divisionCode);
        }

		#endregion

		#region Static Methods

		///<Developers>
		///	<Developer>D. Askew</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>6/14/2004</CreationDate>
		///<TestCases>
		///
		///<Case type="0" testid ="4753"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>ArrayList</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="4754"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// GetHemolysisInspectionList
		/// </summary>
		/// <returns>ArrayList of hemolysis inspection codes and descriptions</returns>
		public static ArrayList GetHemolysisInspectionList()
		{
			return TableToList(DAL.PatientTransfusionReaction.GetHemolysisInspectionList());
		}

		///<Developers>
		///	<Developer>D. Askew</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>6/14/2004</CreationDate>
		///<TestCases>
		///
		///<Case type="0" testid ="4751"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>ArrayList</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="4752"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// GetPatientSymptomList
		/// </summary>
		/// <returns>ArrayList of symptom ids and descriptions</returns>
		public static ArrayList GetPatientSymptomList()
		{
			return TableToList(DAL.PatientTransfusionReaction.GetPatientSymptomList());
		}

		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/20/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="4447"> 
		///		<ExpectedInput>Valid Patient Guid</ExpectedInput>
		///		<ExpectedOutput>ArrayList</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="4448"> 
		///		<ExpectedInput>Invalid Patient Guid</ExpectedInput>
		///		<ExpectedOutput>Empty ArrayList</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// GetTransfusionReactionsForPatient
		/// </summary>
		/// <param name="patientGuid"></param>
		/// <returns>ArrayList of PatientTransfusionReaction objects</returns>
		public static ArrayList GetTransfusionReactionsForPatient(System.Guid patientGuid)
		{
			System.Collections.ArrayList dataArray = new System.Collections.ArrayList();

			System.Data.DataTable dtReactions = DAL.PatientTransfusionReaction.GetTransfusionReactionsForPatient(patientGuid);

			foreach (System.Data.DataRow dr in dtReactions.Rows)
			{
				BOL.PatientTransfusionReaction tmpObj = new BOL.PatientTransfusionReaction(dr);
				dataArray.Add(tmpObj);
			}

			return(dataArray);
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>9/9/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="8181"> 
		///		<ExpectedInput>Valid patient guid</ExpectedInput>
		///		<ExpectedOutput>Count of transfusion reactions</ExpectedOutput>
		///	</Case>
		///
		///
		///<Case type="1" testid ="8182"> 
		///		<ExpectedInput>Invalid patient guid</ExpectedInput>
		///		<ExpectedOutput>ArgumentException thrown</ExpectedOutput>
		///	</Case>
		///
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		///	Get count of transfusion reactions for a patient
		/// </summary>
		/// <param name="patientGuid">Patient Guid</param>
		/// <returns>Transfusion reaction count</returns>
		public static int GetTransfusionReactionsForPatientCount(System.Guid patientGuid)
		{
			if (patientGuid == Guid.Empty)
			{
				throw new ArgumentException(Common.StrRes.SysErrMsg.Common.InvalidFormat("patient").ResString);
			}
			//
			return DAL.PatientTransfusionReaction.GetTransfusionReactionsForPatientCount(patientGuid);
		}

		///<Developers>
		///	<Developer>Rob Heiberger</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>2/16/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="6699"> 
		///		<ExpectedInput>Valid Parameters</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///
		///<Case type="1" testid ="6700"> 
		///		<ExpectedInput>Invalid Parameters</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// GetCompletedPatientTransfusionReactions
		/// </summary>
		/// <returns></returns>
		public static DataTable GetCompletedPatientTransfusionReactions()
		{
			return DAL.PatientTransfusionReaction.GetCompletedPatientTransfusionReactions();
		}


		/// <summary>
		/// TableToList
		/// </summary>
		/// <param name="table"></param>
		/// <returns></returns>
		private static ArrayList TableToList(DataTable table)
		{
			ArrayList mainList = new ArrayList();

			foreach (DataRow dr in table.Rows)
			{
				ArrayList record = new ArrayList();

				foreach (DataColumn dc in table.Columns)
				{
					record.Add(dr[dc]);
				}

				mainList.Add(record);
			}

			return mainList;
		}

		#endregion
	}
}
